# Union

现有员工信息表和顾客信息表如下

```mysql
create table employee(
    id int primary key auto_increment,
    name varchar(256),
    address varchar(1024),
    dept varchar(64)
    -- ignore more
);

create table customer(
                         id int primary key auto_increment,
                         name varchar(256),
                         address varchar(1024),
                         level int
    -- ignore more
)

```

Joe 需要员工和顾客的联系方式（姓名+地址）清单，用于邮寄礼品。这个查询如何写？

## 答案

```mysql
select name, address 
from customer
union
select name, address
from employee
```

## 选项

### A

```mysql
select * 
from customer
union
select *
from employee
```

### B

```mysql
select * 
from customer
join employee
```

### C

```mysql
select * 
from customer
join employee on customer.id = employee.id
```

### D

```mysql
select * 
from customer, employee
```

### E

```mysql
select name, address 
from customer, employee
```

